;;************************************************************************
;; overlay2.lsp 
;; contains code for :do-click and :draw-button methods for graph overlay
;; copyright (c) 1998 by Forrest W. Young
;;************************************************************************


(defmeth vista-graph-overlay-proto :switch-pop-state ()
  (send self :pop-state (not (send self :pop-state)))
  (send (slot-value 'graph) :pop-out (send self :pop-state))
  (when (not (send self :pop-state)) 
        (send self :zoom-state nil)
        (send (send self :graph) :zoom-zip nil))
  )


(defmeth vista-graph-overlay-proto :do-click-pull-down-menu (x y)
  (let* ((graph (slot-value 'graph))
         (vr (send graph :view-rect))
         (cr (send graph :content-rect))
         (menux (+ (first vr) (third vr) -13))
         (menuy 4)
         )
    (when (and (< menux x (+ menux 8)) (< menuy y (+ menuy 8)))
          (send (send graph :menu) :popup x y graph))
    ))

(defmeth vista-graph-overlay-proto :do-click (x y m1 m2)
  (let* ((graph (slot-value 'graph))
         (lefts (send self :lefts))
         (height 10)
         (width  10)
         (gap 2)
         (topx 10)
         (topy 3)
         (topy-atbottom (+ 4 (- (send graph :canvas-height) 
                                (fourth (send graph :margin)))))
         (bottom (+ topy height gap))
         (idling (select (copy-list (list (send graph :idle-on))) 0))
         (i 0)
         (direction)
         )
    (defun new-bins (x y)
      (send graph :new-bins direction))
    
    (when *plot-menu-hot-spot* (send self :do-click-pull-down-menu x y))

    (when (< y bottom)
          (when (send self :plot-help)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send graph :plot-help)
                      (pause 10)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :color)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button 
                            (not (send graph :use-color)) i)
                      (send self  :color-mode (not (send graph :use-color)))
                      (send graph :switch-use-color)
                      (send graph :redraw-overlays)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :mouse-mode)
                
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send graph :choose-mouse-mode)
                      (pause 10)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :pop)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send self :switch-pop-state)
                      (pause 10)
                      
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :zoom)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 15)
                      (send graph :start-buffering)
                      (send self :zoom-state (not (send self :zoom-state)))
                      (send self :pop-state (send self :zoom-state))
                      (send graph :pop-out (send self :zoom-state))
                      (send self :setup-redraw)
                      (send self :draw-button nil i)
                      (send graph :zoom-zip (send self :zoom-state))
                      (send graph :buffer-to-screen)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :options)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 10)
                      (send graph :options-button-action)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :switch)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 10)
                      (send graph :switch-button-action)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :new-x)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send graph :new-x)
                      (pause 10)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :new-y)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send graph :new-y)
                      (pause 10)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :new-z)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (send graph :new-z)
                      (pause 10)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :box)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button 
                            (not (send graph :show-box)) i)
                      (send graph :switch-add-box)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :iterate)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :iter8)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :random)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :random)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :param)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :param)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :undo)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :undo-graph-change m1 m2)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :equate)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button 
                            (not (send graph :equate)) i)
                            (send graph :switch-equate))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :tiles)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :fill-tiles)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :bins)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :new-bins)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :smooth)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button 
                            (not (send graph :show-smooth)) i)
                      (send graph :switch-add-smooth))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :normal)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button 
                            (not (send graph :show-normal)) i)
                      (send graph :switch-add-normal))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :density)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :choose-density)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :connect)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send self :draw-button t i)
                      (send graph :choose-connection)
                      (pause 10)
                      (send self :draw-button nil i))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          )
    (when (> y topy-atbottom)
          (setf i (send self :num-top-buttons))
          (when (send self :bin2)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x 
                              (+ width (select lefts i)))
                           (< topy-atbottom y (+ topy-atbottom height)))
                      (send self :draw-button t i :bottom t)
                      (setf direction nil)
                      (new-bins x y)
                      (pause 10)
                      (send graph :while-button-down #'new-bins nil)
                      (send self :draw-button nil i 
                            :plus-minus nil :bottom t))
                (send graph :idle-on idling)
                (setf i (1+ i))
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x 
                              (+ width (select lefts i)))
                           (< topy-atbottom y (+ topy-atbottom height)))
                      (send self :draw-button t i :bottom t)
                      (setf direction t)
                      (new-bins x y)
                      (pause 10)
                      (send graph :while-button-down #'new-bins nil)
                      (send self :draw-button nil i 
                            :plus-minus t :bottom t))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :curves)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x 
                              (+ width (select lefts i)))
                           (< topy-atbottom y (+ topy-atbottom height)))
                      (send self :draw-button t i :bottom t)
                      (send graph :choose-density)
                      (send self :draw-button nil i :bottom t))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :plot)
                (send graph :idle-on nil)
                (when (and (< (select lefts i) x 
                              (+ width (select lefts i)))
                           (< topy-atbottom y (+ topy-atbottom height)))
                      (send self :draw-button t i :bottom t)
                      (send graph :switch-plot-type)
                      (send self :draw-button nil i :bottom t))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          (when (send self :savedata)
                (when (and (< (select lefts i) x 
                              (+ width (select lefts i)))
                           (< topy-atbottom y (+ topy-atbottom height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i :bottom t)
                      (send graph :create-freq-data)
                      (pause 10)
                      (send self :draw-button nil i :bottom t))
                (send graph :idle-on idling)
                (setf i (1+ i)))
          )
    ))
                
#|
(defmeth vista-graph-overlay-proto :draw-button 
  (paint i &key (plus-minus nil set) bottom (vr (list 0 0 0 0))
         (button-color 'black) (text-color 'black))
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (lefts (send self :lefts))
         (a (+ (first vr)(select (send self :lefts) i)))
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (b (+ (second vr) 3))
         (c 10)
         (d 10))
    (when bottom
          (setf b (+ 4 (- (send graph :canvas-height) 
                          (fourth (send graph :margin))))))
    (when (not button-list)
          (send self :buttons (repeat nil (length (send self :lefts)))))
    (setf (select button-list i) paint)
    (send self :buttons button-list)
    (when (or (= *color-mode* 0) (not (send graph :use-color)))
          (setf on-color 'black)
          (setf off-color 'white))
    (cond 
      (paint 
       (send (send self :graph) :draw-color on-color)
       (send (send self :graph) :paint-rect a b c d)
       (send (send self :graph) :draw-color button-color)
       (send (send self :graph) :frame-rect a b c d))
      (t
       (send (send self :graph) :draw-color off-color)
       (send (send self :graph) :paint-rect a b c d)
       (send (send self :graph) :draw-color button-color)
       (send (send self :graph) :frame-rect a b c d)))
    (send graph :draw-color text-color)
    (send graph :draw-string (select (send self :strings) i) 
          (+ a d 2) (+ b (- c 1)))
    (send graph :draw-color draw-color)
    (when set
          (let ((lw (send graph :line-width))
                (g 1)
                (h 0)
                (j 1))
            #+macintosh (setf g 0)
            #+macintosh (setf h 1) 
            #+macintosh (setf j 0)
            (send graph :draw-line 
                  (+ g a 1)       (- (+ b (ceiling (/ d 2))) h)
                  (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h))
            (send graph :draw-line 
                  (+ g a 1) (- (+ b (ceiling (/ d 2))) h 1)
                  (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h 1))
            (when plus-minus
                  (send graph :draw-line
                        (+ a g (- (floor (/ c 2)) 1)) (+ b j 1)
                        (+ a g (- (floor (/ c 2)) 1)) (+ b j (- d 3)))
                  (send graph :draw-line
                        (+ a g (- (floor (/ c 2)) 2)) (+ b j 1)
                        (+ a g (- (floor (/ c 2)) 2)) (+ b j (- d 3))))

            (send graph :line-width lw)))
    ))
|#
           

(defmeth vista-graph-overlay-proto :initialize-vertical-offset (strings)
  (let* ((big-string "")
         (knt (length strings))
         )
    (dotimes (i knt)
              (setf big-string (strcat big-string (select strings i))))
    (send self :vertical-offset 
          (+ (* knt 15)
             (send (slot-value 'graph) :text-width big-string)))))

(defmeth vista-graph-overlay-proto :get-vertical-bar-location (a b h prev-diff)
  (let* ((aa)(bb)(diff)
         )
    (setf aa a)
    (setf bb b)
    (setf a b)
    (setf b aa)
    (setf b (- h b))
    (setf diff (- h (send self :vertical-offset)))
    (setf b (- b diff))
    (when (and (= prev-diff 0) (< diff 0))
          (send self :setup-redraw)
          (send self :get-vertical-bar-location aa bb h diff)
          (send self :initialize-vertical-offset (send self :strings)))
    (list a b)))

(defmeth vista-graph-overlay-proto :draw-button 
  (paint i &key (plus-minus nil set) bottom (vr (list 0 0 0 0))
         (button-color 'black) (text-color 'black) 
         (vertical nil) (y 3))
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (lefts (send self :lefts))
         (a (+ (first vr)(select (send self :lefts) i)))
         (ab)
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (vertical-offset (send self :vertical-offset))
         (h (- (second (send graph :size)) (fourth (send graph :margin))))
         (b (+ (second vr) y))
         (c 10)
         (d 10))
    (when (> (min (send graph :size)) 0)
          (when (and vertical (not (send self :vertical-offset)))
                (send self :initialize-vertical-offset (send self :strings)))
          (when bottom
                (setf b (+ 4 (- (send graph :canvas-height) 
                                (fourth (send graph :margin))))))
          (when (not button-list)
                (send self :buttons (repeat nil (length (send self :lefts)))))
          (setf (select button-list i) paint)
          (send self :buttons button-list)
          (when (or (= *color-mode* 0) (not (send graph :use-color)))
                (setf on-color 'black)
                (setf off-color 'white))
          (when vertical (setf ab (send self :get-vertical-bar-location a b h 0))
                (setf a (first ab))
                (setf b (second ab)))
          (cond 
            (paint 
             (send (send self :graph) :draw-color on-color)
             (send (send self :graph) :paint-rect a b c d)
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect a b c d))
            (t
             (send (send self :graph) :draw-color off-color)
             (send (send self :graph) :paint-rect a b c d)
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect a b c d)))
          (send graph :draw-color text-color)
          
          (if vertical
              (send graph :draw-string-up (select (send self :strings) i) 
                    (+ a (- c 1)) (- b 2))
              (send graph :draw-string (select (send self :strings) i) 
                    (+ a d 2) (+ b (- c 1))))
          (send graph :draw-color draw-color)
          
          (when set
                (let ((lw (send graph :line-width))
                      (g 1)
                      (h 0)
                      (j 1))
                  #+macintosh (setf g 0)
                  #+macintosh (setf h 1) 
                  #+macintosh (setf j 0)
                  (send graph :draw-line 
                        (+ g a 1)       (- (+ b (ceiling (/ d 2))) h)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h))
                  (send graph :draw-line 
                        (+ g a 1) (- (+ b (ceiling (/ d 2))) h 1)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h 1))
                  (when plus-minus
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j (- d 3)))
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j (- d 3))))
                  
                  (send graph :line-width lw)))
          (list a b))))